/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.screen.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.chunk.settings.preset.Preset;
import com.terraforged.mod.chunk.settings.preset.PresetManager;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.element.TFButton;
import com.terraforged.mod.client.gui.element.TFLabel;
import com.terraforged.mod.client.gui.element.TFTextBox;
import com.terraforged.mod.client.gui.page.BasePage;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.screen.ConfigScreen;
import com.terraforged.mod.client.gui.screen.Instance;
import com.terraforged.mod.client.gui.screen.ScrollPane;
import com.terraforged.mod.client.gui.screen.overlay.OverlayScreen;
import com.terraforged.mod.client.gui.screen.page.UpdatablePage;
import com.terraforged.mod.config.ConfigManager;
import com.terraforged.mod.util.DataUtils;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.nbt.CompoundNBT;

public class PresetsPage
extends BasePage {
    private static final Predicate<String> NAME_VALIDATOR = Pattern.compile("^[A-Za-z0-9\\-_ ]+$").asPredicate();
    private final Instance instance;
    private final UpdatablePage preview;
    private final Widget previewWidget;
    private final TFTextBox nameInput;
    private final ConfigScreen parent;
    private final PresetManager manager = PresetManager.load();

    public PresetsPage(ConfigScreen parent, Instance instance, UpdatablePage preview, Widget widget) {
        CompoundNBT value = new CompoundNBT();
        value.func_74778_a("name", "");
        this.parent = parent;
        this.preview = preview;
        this.previewWidget = widget;
        this.instance = instance;
        this.nameInput = new TFTextBox("name", value);
        this.nameInput.setColorValidator(NAME_VALIDATOR);
    }

    @Override
    public String getTitle() {
        return GuiKeys.PRESETS.get();
    }

    @Override
    public void close() {
        this.manager.saveAll();
    }

    @Override
    public void save() {
    }

    @Override
    protected void update() {
        this.preview.apply(settings -> DataUtils.fromNBT(this.instance.settingsData, settings));
    }

    @Override
    public void init(OverlayScreen parent) {
        this.rebuildPresetList();
        Page.Column right = this.getColumn(1);
        right.scrollPane.addButton((Widget)this.nameInput);
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_CREATE.get()){

            public void func_230430_a_(MatrixStack matrixStack, int x, int z, float ticks) {
                this.field_230693_o_ = PresetsPage.this.nameInput.isValid();
                super.func_230430_a_(matrixStack, x, z, ticks);
            }

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                Preset preset = new Preset(PresetsPage.this.nameInput.func_146179_b(), PresetsPage.this.instance.copySettings());
                PresetsPage.this.manager.add(preset);
                PresetsPage.this.nameInput.func_146180_a("");
                PresetsPage.this.setSelected(preset);
                PresetsPage.this.load(preset);
                PresetsPage.this.rebuildPresetList();
            }
        });
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_LOAD.get()){

            public void func_230430_a_(MatrixStack matrixStack, int x, int z, float ticks) {
                this.field_230693_o_ = PresetsPage.this.hasSelectedPreset(false);
                super.func_230430_a_(matrixStack, x, z, ticks);
            }

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> PresetsPage.this.load(preset));
            }
        });
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_SAVE.get()){

            public void func_230430_a_(MatrixStack matrixStack, int x, int z, float ticks) {
                this.field_230693_o_ = PresetsPage.this.hasSelectedPreset(true);
                super.func_230430_a_(matrixStack, x, z, ticks);
            }

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    TerraSettings settings = PresetsPage.this.instance.copySettings();
                    PresetsPage.this.manager.add(new Preset(preset.getName(), settings));
                    PresetsPage.this.manager.saveAll();
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_RESET.get()){

            public void func_230430_a_(MatrixStack matrixStack, int x, int z, float ticks) {
                this.field_230693_o_ = PresetsPage.this.hasSelectedPreset(true);
                super.func_230430_a_(matrixStack, x, z, ticks);
            }

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    Preset reset = new Preset(preset.getName(), new TerraSettings());
                    PresetsPage.this.manager.add(reset);
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_DELETE.get()){

            public void func_230430_a_(MatrixStack matrixStack, int x, int z, float ticks) {
                this.field_230693_o_ = PresetsPage.this.hasSelectedPreset(true);
                super.func_230430_a_(matrixStack, x, z, ticks);
            }

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> {
                    if (preset.internal()) {
                        return;
                    }
                    PresetsPage.this.manager.remove(preset.getName());
                    PresetsPage.this.rebuildPresetList();
                });
            }
        });
        right.scrollPane.addButton((Widget)new TFButton(GuiKeys.PRESET_SET_DEFAULTS.get()){

            public void func_230982_a_(double x, double y) {
                super.func_230982_a_(x, y);
                PresetsPage.this.getSelected().ifPresent(preset -> ConfigManager.GENERAL.set(cfg -> cfg.set("default_preset", (Object)preset.getName())));
            }
        });
        right.scrollPane.addButton(this.previewWidget);
        TFButton spacer = PresetsPage.createSpacer();
        for (int i = 0; i < 10; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
    }

    private boolean hasSelectedPreset(boolean checkEditable) {
        return this.getSelected().map(preset -> !checkEditable || !preset.internal()).orElse(false);
    }

    private void load(Preset preset) {
        TerraSettings settings = preset.getSettings();
        this.parent.loadPresetStructures(settings);
        this.instance.sync(settings);
        this.update();
    }

    private void setSelected(Preset preset) {
        ScrollPane pane = this.getColumn((int)0).scrollPane;
        for (ScrollPane.Entry entry : pane.func_231039_at__()) {
            if (!entry.option.func_230458_i_().getString().equalsIgnoreCase(preset.getName())) continue;
            pane.func_241215_a_((AbstractList.AbstractListEntry)entry);
            return;
        }
    }

    private Optional<Preset> getSelected() {
        ScrollPane.Entry entry = (ScrollPane.Entry)this.getColumn((int)0).scrollPane.func_230958_g_();
        if (entry == null) {
            return Optional.empty();
        }
        return this.manager.get(entry.option.func_230458_i_().getString());
    }

    private void rebuildPresetList() {
        Page.Column left = this.getColumn(0);
        left.scrollPane.func_241215_a_(null);
        left.scrollPane.func_230943_a_(true);
        left.scrollPane.func_231039_at__().clear();
        for (Preset preset : this.manager) {
            if (preset.internal()) {
                left.scrollPane.addButton((Widget)new TFLabel(preset.getName(), preset.getDescription(), 0xAAAAAA));
                continue;
            }
            left.scrollPane.addButton((Widget)new TFLabel(preset.getName()));
        }
    }

    private static TFButton createSpacer() {
        return new TFButton(""){

            public void func_230430_a_(MatrixStack matrixStack, int x, int y, float tick) {
            }
        };
    }
}

